function plot_BC(md,options,width,i,data);

%plot neuman
plot_pressureload(md,options,width,i,data)

hold on

%plot dirichlets
h1=plot(md.mesh.x(find(~isnan(md.diagnostic.spcvx(1:md.mesh.numberofvertices,1)))),md.mesh.y(find(~isnan(md.diagnostic.spcvx(1:md.mesh.numberofvertices,1)))),'ro','MarkerSize',14,'MarkerFaceColor','r');
h2=plot(md.mesh.x(find(~isnan(md.diagnostic.spcvy(1:md.mesh.numberofvertices,1)))),md.mesh.y(find(~isnan(md.diagnostic.spcvy(1:md.mesh.numberofvertices,1)))),'bo','MarkerSize',10,'MarkerFaceColor','b');
h3=plot(md.mesh.x(find(~isnan(md.diagnostic.spcvz(1:md.mesh.numberofvertices,1)))),md.mesh.y(find(~isnan(md.diagnostic.spcvz(1:md.mesh.numberofvertices,1)))),'yo','MarkerSize',6 ,'MarkerFaceColor','y');

%update legend
[legend_h,object_h,plot_h,text_strings]=legend();
legend('off');
text_strings{end+1}='vx Dirichlet';
text_strings{end+1}='vy Dirichlet';
if h3, text_strings{end+1}='vz Dirichlet'; end
plot_h(end+1)=h1;
plot_h(end+1)=h2;
if h3, plot_h(end+1)=h3; end
legend(plot_h,text_strings,'location','NorthEast')

hold off
