#!/bin/bash

#get number of CPUS
NUMCPUS=$1;

#version of metis
version=4.0 #outdated, srand48 and drand48 are being redefined in conflict to the stdlib equivalent functions.
#version=5.0.1

#Some cleanup
rm -rf install metis-$version

#Create install directories
mkdir install

#Untar 
tar -zxvf  metis-$version.tar.gz

#Move metis into install directory
mv metis-$version/* install
rm -rf metis-$version

#Apply patches
cd install 
if [[ $version = "4.0" ]];  then
patch -p1 < ../metis-4.0.patch
fi

#Compile metis
if [ -z $NUMCPUS ];
then
	if [[ $version = "4.0" ]];  then
		make
	else
		make config prefix=$ISSM_TIER/externalpackages/metis/install
		make install
	fi
else
	if [[ $version = "4.0" ]];  then
		make
	else
		make config prefix=$ISSM_TIER/externalpackages/metis/install
		make -j $NUMCPUS install
	fi
fi
