#!/bin/bash

#get number of CPUS
NUMCPUS=$1;

#version of mercurial
version=`echo *.tar.gz | sed 's/\.tar\.gz//g' | sed 's/mercurial-//g'`
echo $version

#Some cleanup
rm -rf install mercurial-$version

#Create install directories
mkdir install

#Untar 
tar -zxvf  mercurial-$version.tar.gz

#Move mercurial into install directory
mv mercurial-$version/* install
rm -rf mercurial-$version

#Apply patches
cd install 
#patch Lib/Makefile ../lib_Makefile.patch
exit

#Compile mercurial
if [ -z $NUMCPUS ];
then
	make
else
	make -j $NUMCPUS
fi
